/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.idmaker.service.api.client;

import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

public class IdMakerBackendClient {
    private final RemoteIDMakerBackendService remoteIDMakerBackendService;
    private final ConcurrentMap<String, Queue<Long>> bizId2sequencedIdQueue = new ConcurrentHashMap<String, Queue<Long>>();
    private final ConcurrentMap<String, Queue<Long>> bizId2sequencedIdQueueMysql = new ConcurrentHashMap<String, Queue<Long>>();

    public IdMakerBackendClient(RemoteIDMakerBackendService remoteIDMakerBackendService) {
        this.remoteIDMakerBackendService = remoteIDMakerBackendService;
    }

    protected RemoteIDMakerBackendService getRemoteIDMakerBackendService() {
        return this.remoteIDMakerBackendService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getBatchNextID(String bizID, long batchSize) {
        Queue temp;
        Queue<Long> idQueue = (LinkedBlockingQueue)this.bizId2sequencedIdQueue.get(bizID);
        if (idQueue == null && (temp = (Queue)this.bizId2sequencedIdQueue.putIfAbsent(bizID, idQueue = new LinkedBlockingQueue())) != null) {
            idQueue = temp;
        }
        LinkedBlockingQueue linkedBlockingQueue = idQueue;
        synchronized (linkedBlockingQueue) {
            if (idQueue.isEmpty()) {
                DubboResult<Long> result = this.remoteIDMakerBackendService.getBatchNextID(bizID, batchSize);
                Long firstId = (Long)result.getResult();
                int i = 0;
                while ((long)i < batchSize) {
                    Long l = firstId;
                    Long l2 = firstId = Long.valueOf(firstId + 1L);
                    idQueue.add(l);
                    ++i;
                }
            }
            return (Long)idQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getBatchNextIDMysql(String bizID, long batchSize) {
        Queue temp;
        Queue<Long> idQueue = (LinkedBlockingQueue)this.bizId2sequencedIdQueueMysql.get(bizID);
        if (idQueue == null && (temp = (Queue)this.bizId2sequencedIdQueueMysql.putIfAbsent(bizID, idQueue = new LinkedBlockingQueue())) != null) {
            idQueue = temp;
        }
        LinkedBlockingQueue linkedBlockingQueue = idQueue;
        synchronized (linkedBlockingQueue) {
            if (idQueue.isEmpty()) {
                DubboResult<Long> result = this.remoteIDMakerBackendService.getBatchNextIDMysql(bizID, batchSize);
                Long firstId = (Long)result.getResult();
                int i = 0;
                while ((long)i < batchSize) {
                    Long l = firstId;
                    Long l2 = firstId = Long.valueOf(firstId + 1L);
                    idQueue.add(l);
                    ++i;
                }
            }
            return (Long)idQueue.poll();
        }
    }
}

