/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.idmaker.service.api.client;

import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

public class IdMakerClient {
    private final RemoteIDMakerService remoteIDMakerService;
    private final ConcurrentMap<Integer, Queue<Long>> bizId2idQueue = new ConcurrentHashMap<Integer, Queue<Long>>();
    private final ConcurrentMap<String, Queue<Long>> bizId2sequencedIdQueue = new ConcurrentHashMap<String, Queue<Long>>();

    public IdMakerClient(RemoteIDMakerService remoteIDMakerService) {
        this.remoteIDMakerService = remoteIDMakerService;
    }

    protected RemoteIDMakerService getRemoteIDMakerService() {
        return this.remoteIDMakerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getBatchNextID(int bizID, int batchSize) {
        Queue idQueue = (LinkedBlockingQueue)this.bizId2idQueue.get(bizID);
        if (idQueue == null) {
            idQueue = new LinkedBlockingQueue();
            Queue temp = this.bizId2idQueue.putIfAbsent(bizID, idQueue);
            if (temp != null) {
                idQueue = temp;
            }
        }
        LinkedBlockingQueue linkedBlockingQueue = idQueue;
        synchronized (linkedBlockingQueue) {
            if (idQueue.isEmpty()) {
                DubboResult<List<Long>> result = this.remoteIDMakerService.getBatchNextID(bizID, batchSize);
                List idList = (List)result.getResult();
                idQueue.addAll(idList);
            }
            return (Long)idQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getBatchNextIDSequenced(String bizID, long batchSize) {
        Queue temp;
        Queue<Long> idQueue = (LinkedList)this.bizId2sequencedIdQueue.get(bizID);
        if (idQueue == null && (temp = (Queue)this.bizId2sequencedIdQueue.putIfAbsent(bizID, idQueue = new LinkedList())) != null) {
            idQueue = temp;
        }
        LinkedList linkedList = idQueue;
        synchronized (linkedList) {
            if (idQueue.isEmpty()) {
                DubboResult<Long> result = this.remoteIDMakerService.getBatchNextIDSequenced(bizID, batchSize);
                Long firstId = (Long)result.getResult();
                int i = 0;
                while ((long)i < batchSize) {
                    Long l = firstId;
                    Long l2 = firstId = Long.valueOf(firstId + 1L);
                    idQueue.add(l);
                    ++i;
                }
            }
            return (Long)idQueue.poll();
        }
    }
}

