/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.intersection.service.biz.dao;

import java.util.List;
import javax.annotation.Resource;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseDao {
    @Autowired
    @Qualifier(value="creditsSqlSessionTemplate")
    private SqlSessionTemplate creditsSqlSessionTemplate;
    @Autowired
    @Qualifier(value="goodsSqlSessionTemplate")
    protected SqlSessionTemplate goodsSqlSessionTemplate;
    @Autowired
    @Qualifier(value="tuiaSqlSessionTemplate")
    protected SqlSessionTemplate tuiaSqlSessionTemplate;
    @Resource(name="ckvtableSqlSessionTemplate")
    protected SqlSessionTemplate ckvtableSqlSessionTemplate;

    protected abstract String chooseSchema();

    protected SqlSessionTemplate getSqlSessionTemplate() {
        String schema = this.chooseSchema();
        if ("credits".equals(schema)) {
            return this.creditsSqlSessionTemplate;
        }
        if ("goods".equals(schema)) {
            return this.goodsSqlSessionTemplate;
        }
        if ("tuia".equals(schema)) {
            return this.tuiaSqlSessionTemplate;
        }
        if ("ckvtable".equals(schema)) {
            return this.ckvtableSqlSessionTemplate;
        }
        return null;
    }

    protected String generateFullStatement(String statement) {
        return this.getClass().getName() + "." + statement;
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.getSqlSessionTemplate().selectOne(this.generateFullStatement(statement), parameter);
    }

    public <T> List<T> selectList(String statement, Object parameter) {
        return this.getSqlSessionTemplate().selectList(this.generateFullStatement(statement), parameter);
    }

    public int update(String statement, Object parameter) {
        return this.getSqlSessionTemplate().update(this.generateFullStatement(statement), parameter);
    }

    public int delete(String statement, Object parameter) {
        return this.getSqlSessionTemplate().delete(this.generateFullStatement(statement), parameter);
    }

    public int insert(String statement, Object parameter) {
        return this.getSqlSessionTemplate().insert(this.generateFullStatement(statement), parameter);
    }
}

