/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.intersection.service.biz.dao.ckvtable.impl;

import cn.com.duiba.intersection.service.biz.dao.BaseDao;
import cn.com.duiba.intersection.service.biz.dao.ckvtable.KVDaoService;
import cn.com.duiba.intersection.service.biz.entity.ckvtable.KVEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
class KVDaoServiceImpl
extends BaseDao
implements KVDaoService {
    private static final String TABLE_PREFIX = "tb_kvtable_";

    KVDaoServiceImpl() {
    }

    @Override
    public int insert(KVEntity kvEntity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", this.getTableName(kvEntity.getConsumerId()));
        params.put("kvTableEntity", kvEntity);
        return super.insert("insert", params);
    }

    @Override
    public List<KVEntity> selectByKeys(String space, Long consumerId, Set<String> keys) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", this.getTableName(consumerId));
        params.put("consumerId", consumerId);
        params.put("space", space);
        params.put("keys", keys);
        return this.selectList("selectByKeys", params);
    }

    @Override
    public KVEntity selectByCondition(String space, Long consumerId, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", this.getTableName(consumerId));
        params.put("key", key);
        params.put("consumerId", consumerId);
        params.put("space", space);
        return (KVEntity)this.selectOne("selectByCondition", params);
    }

    @Override
    public int deleteByCondition(String space, Long consumerId, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", this.getTableName(consumerId));
        params.put("key", key);
        params.put("consumerId", consumerId);
        params.put("space", space);
        return this.delete("deleteByCondition", params);
    }

    @Override
    public int incrIntValue(String space, Long consumerId, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", this.getTableName(consumerId));
        params.put("key", key);
        params.put("consumerId", consumerId);
        params.put("space", space);
        return this.update("incIntValue", params);
    }

    @Override
    public int decrIntValue(String space, Long consumerId, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", this.getTableName(consumerId));
        params.put("key", key);
        params.put("consumerId", consumerId);
        params.put("space", space);
        return this.update("decIntValue", params);
    }

    private String getTableName(Long consumerId) {
        if (consumerId == null) {
            throw new IllegalArgumentException("consumerId can't be null!");
        }
        long index = consumerId % 1024L;
        String indexStr = String.valueOf(index);
        String tableSuffix = index < 10L ? "000" + indexStr : (index < 100L ? "00" + indexStr : (index < 1000L ? "0" + indexStr : indexStr));
        return TABLE_PREFIX + tableSuffix;
    }

    @Override
    protected String chooseSchema() {
        return "ckvtable";
    }
}

