/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.intersection.service.biz.job;

import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import cn.com.duiba.intersection.service.biz.service.PlatformBannerService;
import cn.com.duiba.intersection.service.common.tools.DateUtil;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlatformBannerStatusJob
extends AbstractSimpleElasticJob {
    private static final Logger LOGGER = JsonLoggerFactory.getLogger(PlatformBannerStatusJob.class);
    @Autowired
    private PlatformBannerService platformBannerService;

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        Date now = new Date();
        String nowStr = DateUtil.getHourStr((Date)now);
        this.autoEnable(nowStr);
        this.autoDisable(nowStr);
    }

    private void autoEnable(String now) {
        try {
            AtomicInteger count = new AtomicInteger(0);
            this.platformBannerService.autoEnable(now, count);
            LOGGER.info("PlatformBannerJob enable \u5df2\u7ecf\u6267\u884c");
        }
        catch (Exception e) {
            LOGGER.error("PlatformBannerJob enable \u6267\u884c\u62a5\u9519 ", (Throwable)e);
        }
    }

    private void autoDisable(String now) {
        try {
            AtomicInteger count = new AtomicInteger(0);
            this.platformBannerService.autoDisable(now, count);
            LOGGER.info("PlatformBannerJob disable \u5df2\u7ecf\u6267\u884c");
        }
        catch (Exception e) {
            LOGGER.error("PlatformBannerJob disable \u6267\u884c\u62a5\u9519 ", (Throwable)e);
        }
    }
}

