/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.intersection.service.biz.remoteservice.impl;

import cn.com.duiba.intersection.serivce.api.remoteservice.RemoteKVService;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.KVDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.enums.KVSpaceEnum;
import cn.com.duiba.intersection.service.biz.dao.ckvtable.KVDaoService;
import cn.com.duiba.intersection.service.biz.entity.ckvtable.KVEntity;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteKVServiceImpl
implements RemoteKVService {
    private static final Logger log = LoggerFactory.getLogger(RemoteKVServiceImpl.class);
    @Autowired
    private KVDaoService kvDaoService;
    private final Set<String> availableSpaces = new HashSet<String>();

    public RemoteKVServiceImpl() {
        for (KVSpaceEnum kvSpaceEnum : KVSpaceEnum.values()) {
            this.availableSpaces.add(kvSpaceEnum.getSpace());
        }
    }

    public DubboResult<List<KVDto>> gets(String space, Long consumerId, Set<String> keys) {
        if (space == null || consumerId == null || keys == null || keys.isEmpty()) {
            return DubboResult.failResult((String)"Param is null or empty.");
        }
        if (!this.availableSpaces.contains(space)) {
            throw new IllegalArgumentException("space:" + space + " is invalid!");
        }
        try {
            List<KVEntity> kvEntities = this.kvDaoService.selectByKeys(space, consumerId, keys);
            List kvDtos = kvEntities == null || kvEntities.isEmpty() ? Collections.emptyList() : BeanUtils.copyList(kvEntities, KVDto.class);
            return DubboResult.successResult(kvDtos);
        }
        catch (Exception e) {
            log.warn("gets failed, space={}, consumerId={}, keys={}", new Object[]{space, consumerId, keys, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> set(KVDto kvDto) {
        if (kvDto == null) {
            return DubboResult.failResult((String)"kvDto is null.");
        }
        if (!this.availableSpaces.contains(kvDto.getSpace())) {
            throw new IllegalArgumentException("space:" + kvDto.getSpace() + " is invalid!");
        }
        if (kvDto.getIntValue() == null && kvDto.getStringValue() == null) {
            throw new IllegalArgumentException("intValue and stringValue can't be null both!");
        }
        try {
            int count = this.kvDaoService.insert((KVEntity)BeanUtils.copy((Object)kvDto, KVEntity.class));
            return DubboResult.successResult((Object)(count == 1 ? 1 : 0));
        }
        catch (Exception e) {
            log.warn("set failed, kvDto={}", (Object)kvDto, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<KVDto> get(String space, Long consumerId, String key) {
        if (space == null || consumerId == null || key == null) {
            return DubboResult.failResult((String)"Param is null.");
        }
        if (!this.availableSpaces.contains(space)) {
            throw new IllegalArgumentException("space:" + space + " is invalid!");
        }
        try {
            KVEntity kvEntity = this.kvDaoService.selectByCondition(space, consumerId, key);
            KVDto kvDto = (KVDto)BeanUtils.copy((Object)kvEntity, KVDto.class);
            return DubboResult.successResult((Object)kvDto);
        }
        catch (Exception e) {
            log.warn("get failed, space={}, consumerId={}, key={}", new Object[]{space, consumerId, key, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> incrIntValue(String space, Long consumerId, String key) {
        if (space == null || consumerId == null || key == null) {
            return DubboResult.failResult((String)"Param is null.");
        }
        if (!this.availableSpaces.contains(space)) {
            throw new IllegalArgumentException("space:" + space + " is invalid!");
        }
        try {
            int count = this.kvDaoService.incrIntValue(space, consumerId, key);
            return DubboResult.successResult((Object)(count == 1 ? 1 : 0));
        }
        catch (Exception e) {
            log.warn("incrIntValue failed, space={}, consumerId={}, key={}", new Object[]{space, consumerId, key, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> decrIntValue(String space, Long consumerId, String key) {
        if (space == null || consumerId == null || key == null) {
            return DubboResult.failResult((String)"Param is null.");
        }
        if (!this.availableSpaces.contains(space)) {
            throw new IllegalArgumentException("space:" + space + " is invalid!");
        }
        try {
            int count = this.kvDaoService.decrIntValue(space, consumerId, key);
            return DubboResult.successResult((Object)(count == 1 ? 1 : 0));
        }
        catch (Exception e) {
            log.warn("decrIntValue failed, space={}, consumerId={}, key={}", new Object[]{space, consumerId, key, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> remove(String space, Long consumerId, String key) {
        if (space == null || consumerId == null || key == null) {
            return DubboResult.failResult((String)"Param is null.");
        }
        if (!this.availableSpaces.contains(space)) {
            throw new IllegalArgumentException("space:" + space + " is invalid!");
        }
        try {
            int count = this.kvDaoService.deleteByCondition(space, consumerId, key);
            return DubboResult.successResult((Object)(count == 1 ? 1 : 0));
        }
        catch (Exception e) {
            log.warn("remove failed, space={}, consumerId={}, key={}", new Object[]{space, consumerId, key, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

