/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.intersection.service.biz.service.impl;

import cn.com.duiba.intersection.serivce.api.remoteservice.dto.AppTagDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.PlatformBannerDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.PlatformBannerEditDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.PlatformBannerPageDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.PlatformBannerSaveDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.enums.BannerTypeEnum;
import cn.com.duiba.intersection.serivce.api.remoteservice.enums.BizCodeEnum;
import cn.com.duiba.intersection.serivce.api.remoteservice.enums.DeletedEnum;
import cn.com.duiba.intersection.serivce.api.remoteservice.enums.EnableEnum;
import cn.com.duiba.intersection.serivce.api.remoteservice.tools.Page;
import cn.com.duiba.intersection.service.biz.dao.goods.PlatformBannerDao;
import cn.com.duiba.intersection.service.biz.entity.goods.PlatformBannerEntity;
import cn.com.duiba.intersection.service.biz.service.AppTagService;
import cn.com.duiba.intersection.service.biz.service.PlatformBannerService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="platformBannerService")
public class PlatformBannerServiceImpl
implements PlatformBannerService {
    @Autowired
    private PlatformBannerDao platformBannerDao;
    @Autowired
    private AppTagService appTagService;

    @Override
    public List<PlatformBannerDto> findPlatformBanners(Long appId, BizCodeEnum bizCode) {
        List<PlatformBannerEntity> entities = this.platformBannerDao.selectAllEnableByBizCode(bizCode.value());
        AppTagDto appTag = this.appTagService.getAppTagById(appId);
        if (appTag == null) {
            return BeanUtils.copyList(entities, PlatformBannerDto.class);
        }
        if (appTag.getAppId() == null || StringUtils.isBlank((CharSequence)appTag.getAppTags())) {
            return BeanUtils.copyList(entities, PlatformBannerDto.class);
        }
        ArrayList<String> appTags = new ArrayList<String>(Arrays.asList(appTag.getAppTags().split(",")));
        Iterator<PlatformBannerEntity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            PlatformBannerEntity it = iterator.next();
            if (StringUtils.isBlank((CharSequence)it.getTags())) continue;
            ArrayList<String> pbTags = new ArrayList<String>(Arrays.asList(it.getTags().split(",")));
            pbTags.retainAll(appTags);
            if (pbTags.isEmpty()) continue;
            iterator.remove();
        }
        return BeanUtils.copyList(entities, PlatformBannerDto.class);
    }

    @Override
    public boolean enable(Long bannerId) {
        int ret = this.platformBannerDao.enable(bannerId);
        return ret > 0;
    }

    @Override
    public void save(PlatformBannerSaveDto dto, BizCodeEnum bizCode) {
        if (dto.getId() == null) {
            if (BannerTypeEnum.URL.value() == dto.getBannerType().intValue()) {
                dto.setBannerContent(dto.getUrl());
            } else if (BannerTypeEnum.ACTIVITY.value() == dto.getBannerType().intValue()) {
                String bannerContent = String.format("%s-%s", dto.getBannerActivityTypeEnum().value(), dto.getActivityId());
                dto.setBannerContent(bannerContent);
            }
            PlatformBannerEntity entity = new PlatformBannerEntity();
            BeanUtils.copy((Object)dto, (Object)entity);
            entity.setEnable(EnableEnum.DISABLE.value());
            entity.setDeleted(DeletedEnum.NOT_DELETED.value());
            entity.setBizCode(bizCode.value());
            this.platformBannerDao.insert(entity);
        } else {
            PlatformBannerEntity entity = new PlatformBannerEntity();
            if (BannerTypeEnum.URL.value() == dto.getBannerType().intValue()) {
                dto.setBannerContent(dto.getUrl());
            } else if (BannerTypeEnum.ACTIVITY.value() == dto.getBannerType().intValue()) {
                String bannerContent = String.format("%s-%s", dto.getBannerActivityTypeEnum().value(), dto.getActivityId());
                dto.setBannerContent(bannerContent);
            }
            BeanUtils.copy((Object)dto, (Object)entity);
            this.platformBannerDao.update(entity);
        }
    }

    @Override
    public PlatformBannerEditDto findPlatformBanner4Edit(Long bannerId) {
        PlatformBannerEditDto rst = new PlatformBannerEditDto();
        PlatformBannerEntity entity = this.platformBannerDao.select(bannerId);
        if (entity != null) {
            BeanUtils.copy((Object)entity, (Object)rst);
            if (BannerTypeEnum.ACTIVITY.value() == rst.getBannerType().intValue()) {
                if (StringUtils.isNotBlank((CharSequence)rst.getBannerContent())) {
                    String[] content = rst.getBannerContent().split("-");
                    rst.setActivityType(content[0]);
                    rst.setActivityId(Long.valueOf(content[1]));
                }
            } else if (StringUtils.isNotBlank((CharSequence)rst.getBannerContent())) {
                rst.setUrl(rst.getBannerContent());
            }
            return rst;
        }
        return null;
    }

    @Override
    public boolean delete(Long bannerId) {
        int ret = this.platformBannerDao.delete(bannerId);
        return ret > 0;
    }

    @Override
    public boolean disable(Long bannerId) {
        int ret = this.platformBannerDao.disable(bannerId);
        return ret > 0;
    }

    @Override
    public Page<PlatformBannerPageDto> findPlatformBannersPage(int current, int pageSize, BizCodeEnum bizCode) {
        Page page = new Page();
        List<PlatformBannerEntity> list = this.platformBannerDao.findByPage(current, pageSize, bizCode.value());
        List dtos = BeanUtils.copyList(list, PlatformBannerPageDto.class);
        Long count = this.platformBannerDao.count(bizCode.value());
        page.setList(dtos);
        page.setTotalCount((int)count.longValue());
        return page;
    }

    @Override
    public void autoEnable(String now, AtomicInteger count) throws Exception {
        try {
            this.platformBannerDao.autoEnable(now);
        }
        catch (Exception e) {
            if (count.addAndGet(1) > 3) {
                throw e;
            }
            this.autoEnable(now, count);
        }
    }

    @Override
    public void autoDisable(String now, AtomicInteger count) throws Exception {
        try {
            this.platformBannerDao.autoDisable(now);
        }
        catch (Exception e) {
            if (count.addAndGet(1) > 3) {
                throw e;
            }
            this.autoDisable(now, count);
        }
    }
}

