/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.intersection.service.common.tools;

import cn.com.duiba.intersection.service.common.tools.Base58;
import java.security.Key;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class BlowfishUtils {
    private static final String CIPHER_NAME = "Blowfish/CFB8/NoPadding";
    private static final String KEY_SPEC_NAME = "Blowfish";
    private static final ThreadLocal<HashMap<String, BlowfishUtils>> pool = new ThreadLocal();
    private Cipher enCipher;
    private Cipher deCipher;
    private String key;

    private BlowfishUtils(String key) {
        try {
            this.key = key;
            String iv = StringUtils.substring((String)DigestUtils.md5Hex((String)key), (int)0, (int)8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), KEY_SPEC_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
            this.enCipher = Cipher.getInstance(CIPHER_NAME);
            this.deCipher = Cipher.getInstance(CIPHER_NAME);
            this.enCipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            this.deCipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String encryptBlowfish(String s, String key) {
        return BlowfishUtils.getInstance(key).encrypt(s);
    }

    public static String decryptBlowfish(String s, String key) {
        return BlowfishUtils.getInstance(key).decrypt(s);
    }

    public static String encryptBlowfish(String s) {
        return BlowfishUtils.encryptBlowfish(s, "abc");
    }

    public static String decryptBlowfish(String s) {
        return BlowfishUtils.decryptBlowfish(s, "abc");
    }

    private static BlowfishUtils getInstance(String key) {
        BlowfishUtils instance;
        HashMap<String, BlowfishUtils> keyMap = pool.get();
        if (keyMap == null || keyMap.isEmpty()) {
            keyMap = new HashMap();
            pool.set(keyMap);
        }
        if ((instance = keyMap.get(key)) == null || !StringUtils.equals((String)instance.key, (String)key)) {
            instance = new BlowfishUtils(key);
            keyMap.put(key, instance);
        }
        return instance;
    }

    private String encrypt(String s) {
        String result = null;
        if (StringUtils.isNotBlank((String)s)) {
            try {
                byte[] encrypted = this.enCipher.doFinal(s.getBytes());
                result = new String(Base58.encode(encrypted));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String decrypt(String s) {
        String result = null;
        if (StringUtils.isNotBlank((String)s)) {
            try {
                byte[] decrypted = Base58.decode(s);
                result = new String(this.deCipher.doFinal(decrypted));
            }
            catch (Exception e) {
                this.resetInstance();
                e.printStackTrace();
            }
        }
        return result;
    }

    private void resetInstance() {
        pool.set(null);
    }
}

