/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.credits.sdk;

import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditAuditParams;
import cn.com.duiba.credits.sdk.CreditConfirmParams;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.credits.sdk.CreditNeedAuditParams;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditTool {
    private String appKey;
    private String appSecret;

    public CreditTool(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public String buildUrlWithSign(String url, Map<String, String> params) {
        HashMap<String, String> newparams = new HashMap<String, String>(params);
        newparams.put("appKey", this.appKey);
        newparams.put("appSecret", this.appSecret);
        if (newparams.get("timestamp") == null) {
            newparams.put("timestamp", System.currentTimeMillis() + "");
        }
        String sign = SignTool.sign(newparams);
        newparams.put("sign", sign);
        newparams.remove("appSecret");
        return AssembleTool.assembleUrl(url, newparams);
    }

    public String buildCreditAutoLoginRequest(String uid, Long credits) {
        String url = "http://www.duiba.com.cn/autoLogin/autologin?";
        HashMap<String, String> params = new HashMap<String, String>();
        Long timestamp = new Date().getTime();
        params.put("uid", uid);
        params.put("credits", credits + "");
        params.put("appSecret", this.appSecret);
        params.put("appKey", this.appKey);
        params.put("timestamp", timestamp + "");
        String sign = SignTool.sign(params);
        url = url + "uid=" + uid + "&credits=" + credits + "&appKey=" + this.appKey + "&sign=" + sign + "&timestamp=" + timestamp;
        return url;
    }

    public String buildCreditOrderStatusRequest(String orderNum, String bizId) {
        if (orderNum == null) {
            orderNum = "";
        }
        if (bizId == null) {
            bizId = "";
        }
        String url = "http://www.duiba.com.cn/status/orderStatus?";
        HashMap<String, String> params = new HashMap<String, String>();
        Long timestamp = new Date().getTime();
        params.put("orderNum", orderNum);
        params.put("bizId", bizId);
        params.put("appKey", this.appKey);
        params.put("appSecret", this.appSecret);
        params.put("timestamp", timestamp + "");
        String sign = SignTool.sign(params);
        url = url + "orderNum=" + orderNum + "&bizId=" + bizId + "&appKey=" + this.appKey + "&sign=" + sign + "&timestamp=" + timestamp;
        return url;
    }

    public String buildCreditAuditRequest(CreditAuditParams params) {
        String s;
        String url = "http://www.duiba.com.cn/audit/apiAudit?";
        HashMap<String, String> signParams = new HashMap<String, String>();
        Long timestamp = new Date().getTime();
        signParams.put("appKey", this.appKey);
        signParams.put("appSecret", this.appSecret);
        signParams.put("timestamp", timestamp + "");
        if (params.getPassOrderNums() != null && params.getPassOrderNums().size() > 0) {
            s = null;
            for (String o : params.getPassOrderNums()) {
                if (s == null) {
                    s = o;
                    continue;
                }
                s = s + "," + o;
            }
            signParams.put("passOrderNums", s);
        } else {
            signParams.put("passOrderNums", "");
        }
        if (params.getRejectOrderNums() != null && params.getRejectOrderNums().size() > 0) {
            s = null;
            for (String o : params.getRejectOrderNums()) {
                if (s == null) {
                    s = o;
                    continue;
                }
                s = s + "," + o;
            }
            signParams.put("rejectOrderNums", s);
        } else {
            signParams.put("rejectOrderNums", "");
        }
        String sign = SignTool.sign(signParams);
        url = url + "appKey=" + this.appKey + "&passOrderNums=" + (String)signParams.get("passOrderNums") + "&rejectOrderNums=" + (String)signParams.get("rejectOrderNums") + "&sign=" + sign + "&timestamp=" + timestamp;
        return url;
    }

    public String buildCreditConfirmRequest(CreditConfirmParams p) {
        String url = "http://www.duiba.com.cn/confirm/confirm?";
        HashMap<String, String> params = new HashMap<String, String>();
        Long timestamp = new Date().getTime();
        params.put("appSecret", this.appSecret);
        params.put("appKey", this.appKey);
        params.put("timestamp", timestamp + "");
        params.put("success", p.isSuccess() + "");
        params.put("errorMessage", p.getErrorMessage());
        params.put("orderNum", p.getOrderNum());
        String sign = SignTool.sign(params);
        url = url + "appKey=" + this.appKey + "&sign=" + sign + "&timestamp=" + timestamp + "&success=" + p.isSuccess() + "&errorMessage=" + p.getErrorMessage() + "&orderNum=" + p.getOrderNum();
        return url;
    }

    public CreditConsumeParams parseCreditConsume(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        CreditConsumeParams params = new CreditConsumeParams();
        params.setAppKey(this.appKey);
        params.setUid(request.getParameter("uid"));
        params.setCredits(Long.valueOf(request.getParameter("credits")));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setDescription(request.getParameter("description"));
        params.setOrderNum(request.getParameter("orderNum"));
        params.setType(request.getParameter("type"));
        if (request.getParameter("facePrice") != null) {
            params.setFacePrice(Integer.valueOf(request.getParameter("facePrice")));
        }
        if (request.getParameter("actualPrice") != null) {
            params.setActualPrice(Integer.valueOf(request.getParameter("actualPrice")));
        }
        params.setAlipay(request.getParameter("alipay"));
        params.setPhone(request.getParameter("phone"));
        params.setQq(request.getParameter("qq"));
        if (request.getParameter("waitAudit") != null) {
            params.setWaitAudit(Boolean.valueOf(request.getParameter("waitAudit")));
        }
        params.setIp(request.getParameter("ip"));
        params.setParams(request.getParameter("params"));
        params.setItemCode(request.getParameter("itemCode"));
        return params;
    }

    public CreditNotifyParams parseCreditNotify(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        CreditNotifyParams params = new CreditNotifyParams();
        params.setSuccess(Boolean.valueOf(request.getParameter("success")));
        params.setErrorMessage(request.getParameter("errorMessage"));
        params.setBizId(request.getParameter("bizId"));
        params.setUid(request.getParameter("uid"));
        params.setAppKey(request.getParameter("appKey"));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setOrderNum(request.getParameter("orderNum"));
        return params;
    }

    public CreditNeedAuditParams parseCreditAudit(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        CreditNeedAuditParams params = new CreditNeedAuditParams();
        params.setAppKey(this.appKey);
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setBizId(request.getParameter("bizId"));
        return params;
    }
}

