/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.credits.sdk;

import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.credits.sdk.VirtualCardConsumeParams;
import cn.com.duiba.credits.sdk.VirtualCardNotifyParams;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualCardTool {
    private String appKey;
    private String appSecret;

    public VirtualCardTool(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public String buildUrlWithSign(String url, Map<String, String> params) {
        HashMap<String, String> newparams = new HashMap<String, String>(params);
        newparams.put("appKey", this.appKey);
        newparams.put("appSecret", this.appSecret);
        if (newparams.get("timestamp") == null) {
            newparams.put("timestamp", System.currentTimeMillis() + "");
        }
        String sign = SignTool.sign(newparams);
        newparams.put("sign", sign);
        newparams.remove("appSecret");
        return AssembleTool.assembleUrl(url, newparams);
    }

    public VirtualCardConsumeParams parseVirtualCardConsume(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        VirtualCardConsumeParams params = new VirtualCardConsumeParams();
        params.setAppKey(this.appKey);
        params.setUid(request.getParameter("uid"));
        params.setCount(Long.valueOf(request.getParameter("count")));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setDescription(request.getParameter("description"));
        params.setOrderNum(request.getParameter("orderNum"));
        params.setType(request.getParameter("type"));
        if (request.getParameter("waitAudit") != null) {
            params.setWaitAudit(Boolean.valueOf(request.getParameter("waitAudit")));
        }
        params.setIp(request.getParameter("ip"));
        params.setParams(request.getParameter("params"));
        params.setTransfer(request.getParameter("transfer"));
        return params;
    }

    public VirtualCardNotifyParams parseVirtualCardNotify(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        VirtualCardNotifyParams params = new VirtualCardNotifyParams();
        params.setSuccess(Boolean.valueOf(request.getParameter("success")));
        params.setErrorMessage(request.getParameter("errorMessage"));
        params.setBizId(request.getParameter("bizId"));
        params.setUid(request.getParameter("uid"));
        params.setAppKey(request.getParameter("appKey"));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setOrderNum(request.getParameter("orderNum"));
        return params;
    }
}

