package cn.com.duiba.kjj.center.api.dto.promotion;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-10 15:44
 * 用户优惠码使用记录
 */
@Data
public class PromotionCodeDto implements Serializable {

    private static final long serialVersionUID = -7062345584263905846L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 邀请码
     */
    private String promotionCode;

    /**
     * 优惠码使用状态
     * @see cn.com.duiba.kjj.center.api.enums.promotion.PromotionCodeStatusEnum
     */
    private Integer promotionCodeStatus;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 批次
     */
    private Long batchId;

    /**
     * 有效期截止时间
     */
    private Date deadline;

    /**
     * 使用时间
     */
    private Date usedTime;

    /**
     * 使用时间
     */
    private Date activateDate;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 扫码加锁时间
     */
    private Date lockTime;

}
