package cn.com.duiba.kjj.center.api.dto.promotion;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-10 13:45
 * 优惠码
 */
@Data
public class PromotionCodeBatchDto implements Serializable {

    private static final long serialVersionUID = -4065151449778203046L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 有效期截止时间
     */
    private Date deadline;

    /**
     * 数量
     */
    private Integer codeTotal;

    /**
     * 已使用的数量
     */
    private Integer usedNum;

    /**
     * 位数
     */
    private Integer digitTotal;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 批次邀请码组成规则
     */
    private String batchCodeRule;

    /**
     * 二维码地址
     */
    private String qrCode;

    /**
     * 客集集内部销售员名称
     */
    private String internalSellerName;

    /**
     * 讲师名称
     */
    private String lecturerName;

    /**
     * 优惠码的开始时间
     */
    private Date startTime;

    /**
     * 优惠码的结束时间
     */
    private Integer price;

    /**
     * 客集集内部销售员id
     */
    private Long agentSellerId;

    /**
     * 所在省份
     */
    private String province;

    /**
     * 所在城市
     */
    private String city;

    /**
     * 用户版本信息
     *
     * @see cn.com.duiba.kjj.center.api.enums.user.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 套餐ID tb_combo.id
     */
    private Long comboId;

    /**
     * 会员有效期时长（月）
     */
    private Integer validityDuration;

    /**
     * 优惠码类型
     *
     * @see cn.com.duiba.kjj.center.api.enums.promotion.PromotionCodeTypeEnum
     */
    private Integer promotionType;
}
