package cn.com.duiba.kjj.center.api.dto.vip.order;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售员付款记录
 * @author kjj mybatis generator 
 * @date 2021-11-09
 */
@Data
public class SellerPayRecordDto implements Serializable {

    private static final long serialVersionUID = 16364414159438636L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户付款金额,单位：分
     */
    private Long amount;

    /**
     * 付款状态，1=待付款、2=付款中、3=付款成功、4=付款失败
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.SellerPayStatusEnum
     */
    private Integer payStatus;

    /**
     * 交易号(业务订单号)
     */
    private String tradeNo;

    /**
     * duiba订单号(商户订单号)
     */
    private String duibaTradeNo;

    /**
     * 支付截止时间
     */
    private Date timeExpire;

    /**
     * 微信交易号(微信订单号)
     */
    private String payTradeNo;

    /**
     * 支付结果时间
     */
    private Date payResultTime;

    /**
     * 代付人
     */
    private Long presentUserId;

    /**
     * 邀请码
     */
    private String promotionCode;

    /**
     * 异常信息
     */
    private String exceptionMessage;

    /**
     * 支付来源：1公众号-推送、2公众号开通会员、3文章页面-文中广告位
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.VipOrderPaySourceEnum
     */
    private Integer paySource;

    /**
     * 用户版本 1:通用版 2:保险专业版
     * @see cn.com.duiba.kjj.center.api.enums.user.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 支付渠道，默认公众号
     * @see cn.com.duiba.kjy.paycenter.api.enums.ChannelTypeEnum
     */
    private String channelType;

    /**
     * 会员有效时长(月)
     */
    private Integer validityDuration;

    /**
     * 入口折扣类型，1-普通，3-邀请，4-优惠码，若入口没有带类型
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.VipOrderDiscountTypeEnum
     */
    private Integer entryDiscountType;

    /**
     * 实际折扣类型，1-普通，2-续费，3-邀请，4-优惠码
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.VipOrderDiscountTypeEnum
     */
    private Integer discountType;
}