package cn.com.duiba.kjj.center.api.enums.seller;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-11 15:42
 * 销售来源定义
 */
@Getter
@AllArgsConstructor
public enum SellerFromEnum {

    /**
     * 销售来源场景
     */
    NORMAL("0", "一般途径"),
    POSTER_INVITE("1", "海报邀请(普通邀请)"),
    CARD("2", "文章、午报、晚报换名片邀请(普通邀请)"),
    SITE_SALE_QR("3", "会销扫码（会销邀请）"),
    OUR_INSIDE_RECOMMEND("4", "公司内部销售推荐（只用作绩效记录，不做其它业务用途）"),
    WEEKLY_PUBLICATION("5", "周报中关注客集集"),
    VISITOR_PAYMENT("6", "访客转化为付费用户"),
    NOVICE_TASK("7", "新手任务邀请"),
    PRIVATE_CHAT("15", "私信页面-聊天界面"),
    ACTIVATE_CODE("45", "激活码"),
    WX_MP_BASE_AUTH("46", "小程序授权"),
    PC_OFFICIAL_WEBSITE("77","官网"),
    WX_FISSION_MP_BSE_AUTH("80", "微信裂变小程序授权"),
    WX_GAME_MP_BASE_AUTH("110", "抽奖工具小程序授权"),
    WX_GREETING_MP_BASE_AUTH("111", "节日贺卡小程序授权"),
    VIP_NOT_SUBSCRIBE_VIP_ACCOUNT_PAGE("123", "付费代理人未关注vip公众号弹层二维码"),
    VIP_NOT_SUBSCRIBE_VIP_ACCOUNT_PUSH("124", "代理人通过蓝号推送的VIP公众号图片关注VIP公众号"),
    DAILY_CHANGE_CARD("126", "早报换名片邀请(普通邀请)"),
    VIDEO_CHANGE_CARD("137", "视频换名片邀请(普通邀请)"),
    CARTOON_CHANGE_CARD("127", "动画换名片邀请(普通邀请)"),
    GAME_ANSWER_CHANGE_CARD("135", "小游戏换名片邀请(普通邀请)"),
    GAME_LOTTERY_CHANGE_CARD("136", "抽奖工具换名片邀请(普通邀请)"),
    OTHER_CHANGE_CARD("134", "其他内容页换名片邀请(普通邀请)"),
    DAILY_CHANGE_MYPOINT("143", "早报换我的观点(换成我的观点弹层)"),
    PRE_INSTALL("159","会员预设"),
    VIP_TRANSFET("164", "会员转移"),
    OPEN_USER("165","第三方公众号用户"),
    MORNING_POSTER("166", "早安海报扫码来源"),
    EVENING_POSTER("167", "晚安海报扫码来源"),
    GUIDE_MORNING_CLOCK("168", "用户引导-早安打卡"),
    GUIDE_EVENING_CLOCK("169", "用户引导-晚安打卡"),
    GUIDE_EVERYDAY_QUESTION("170", "用户引导-每日一问(已更新)"),
    LIVE_VISITOR_MAP_COMPANY_NAME_LIST("194", "直播访客匹配架构名单成为代理人"),
    TRY_USE_CODE("207","试用码扫码来源"),
    LIVE_PREVIEW_SUMMARY("225", "直播预览汇总"),
    COMMON_PAYMENT("230","客集集&客集集VIP用户付费后关注集客助手公众号"),
    CORP_EMPLOYEE_ACTIVATE("231", "企业版员工激活"),
    INVITATION_SCAN("242", "邀请返现关注"),
    ;

    /**
     * 来源
     */
    private final String from;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有类型的set
     */
    private static final Set<String> FROMS = Collections.unmodifiableSet(Arrays.stream(values()).map(SellerFromEnum::getFrom).collect(Collectors.toSet()));

    /**
     * 枚举是否包含此type
     */
    public boolean contains(String from){
        if(Objects.isNull(from)){
            return false;
        }
        return FROMS.contains(from);
    }

}
