package cn.com.duiba.kjj.center.api.enums.vip.order;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 付费折扣类型
 * @author lizhi
 * @date 2021/11/5 12:00 下午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum VipOrderDiscountTypeEnum {

    GENERAL(1, "普通"),
    RENEW(2, "续费"),
    INVITATION(3, "邀请"),
    PROMOTION_CODE(4, "优惠码"),
    ;

    /**
     * 类型
     */
    private final int type;

    /**
     * 描述
     */
    private final String desc;


    private static final Map<Integer, VipOrderDiscountTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(VipOrderDiscountTypeEnum::getType, Function.identity(), (v1, v2) -> {
                log.error("SellerPayDiscountTypeEnum, type distinct, type={}", v2.getType());
                return v2;
            }))
    );

    /**
     * 根据类型获取枚举
     * @param type 类型
     * @return 枚举
     */
    public static VipOrderDiscountTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
