package cn.com.duiba.kjj.center.api.remoteservice.distribution;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.seller.SellerInvitationDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-12 10:05
 */
@AdvancedFeignClient
public interface RemoteSellerDistributionService {

    /**
     * 根据下级销售ID查询邀请关系
     * @param sellerId 代理人ID
     * @return 邀请关系
     */
    SellerInvitationDto findBySellerId(Long sellerId);

    /**
     * 根据上级ID集合查询下级销售ID集合(排除过期的)
     * @param superiorIds  上级销售ID集合
     * @return 下级销售ID集合
     */
    List<Long> findSellerIdsBySuperiorIds(List<Long> superiorIds);

    /**
     * 删除原有邀请关系并新增
     * @param dto 邀请关系
     * @return 操作结果
     */
    boolean insertAndDelOld(SellerInvitationDto dto);
}
