package cn.com.duiba.kjj.center.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.seller.SellerDto;
import cn.com.duiba.kjj.center.api.dto.seller.SellerNameAvatarDto;

import java.util.Map;
import java.util.Set;

/**
 * 销售员
 * @author lizhi
 * @date 2021/11/10 6:15 下午
 */
@AdvancedFeignClient
public interface RemoteSellerService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 销售员
     */
    SellerDto selectById(Long id);

    /**
     * 根据用户ID查询
     * @param userId 用户ID
     * @return 销售员信息
     */
    SellerDto selectByUserId(Long userId);

    /**
     * 查询销售员头像昵称
     * @param id 销售员Id
     * @return 销售员头像昵称
     */
    SellerNameAvatarDto getSellerNameAvatar(Long id);

    /**
     * 批量查询销售员头像昵称
     * @param sellerIds 销售员ID集合
     * @return key：销售员ID，value：销售员头像昵称
     */
    Map<Long, SellerNameAvatarDto> getSellerNameAvatarMap(Set<Long> sellerIds);

    /**
     * 用户是否满足续费条件
     * @param userId 用户ID
     * @return 是否满足付费条件
     */
    boolean renewByUserId(Long userId);

    /**
     * 判断销售是否满足续费条件
     * @param sellerId
     * @return
     */
    boolean renewBySid(Long sellerId);
}
