/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjj.center.api.enums.seller;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;

public enum SellerAccountBizTypeEnum {
    WITHDRAW(1, "\u4f59\u989d\u63d0\u73b0"),
    INVITE_AWARD(2, "\u9080\u8bf7\u5956\u52b1"),
    SECOND_INVITE_AWARD(3, "\u4e8c\u7ea7\u5956\u52b1"),
    WITHDRAW_BACK(4, "\u4f59\u989d\u63d0\u73b0\u5931\u8d25\u9000\u56de"),
    FIRST_ORDER_INVITE_AWARD(5, "\u4e00\u7ea7\u9636\u68af\u9080\u8bf7\u5355\u4eba\u5956\u52b1"),
    FIRST_ORDER_INVITE_EXTRA_AWARD(6, "\u4e00\u7ea7\u9636\u68af\u9080\u8bf7\u4e00\u6b21\u6027\u5956\u52b1"),
    SP_INVITE_AWARD(7, "\u4f1a\u9500\u9080\u8bf7\u8fd4\u4f63"),
    ENOUGH_COMMISSION_AWARD(8, "\u6ee1\u989d\u8fd4\u4f63\u5956\u52b1"),
    TRAIN_AWARD(9, "\u57f9\u8bad\u5956\u52b1"),
    NOVICE_TASK(10, "\u65b0\u624b\u4efb\u52a1"),
    REFUND(11, "\u7528\u6237\u9000\u6b3e"),
    PARTNERSHIP_INVITE_AWARD(12, "\u5408\u4f19\u4eba\u4e00\u7ea7\u9080\u8bf7\u5956\u52b1"),
    SECOND_PARTNERSHIP_INVITE_AWARD(13, "\u5408\u4f19\u4eba\u4e8c\u7ea7\u5956\u52b1"),
    PARTNERSHIP_INVITE_RENEW_AWARD(14, "\u5408\u4f19\u4eba\u5206\u9500\u7eed\u8d39\u5956\u52b1"),
    SECOND_PARTNERSHIP_INVITE_RENEW_AWARD(15, "\u5408\u4f19\u4eba\u5206\u9500\u4e8c\u7ea7\u7eed\u8d39\u5956\u52b1"),
    ATTEND_RED(16, "\u7b7e\u5230\u9886\u7ea2\u5305");

    private final Integer code;
    private final String desc;
    private static final Set<Integer> EXPEND_BIZ_TYPE;
    private static final Set<Integer> ONLY_CHANGE_BALANCE_BIZ_TYPE;
    private static final Set<Integer> RETURN_BIZ_TYPE;

    public static boolean isExpend(Integer bizType) {
        return EXPEND_BIZ_TYPE.contains(bizType);
    }

    public static boolean isOnlyChangeBalance(Integer bizType) {
        return ONLY_CHANGE_BALANCE_BIZ_TYPE.contains(bizType);
    }

    public static boolean containsReturnBizType(Integer bizType) {
        return RETURN_BIZ_TYPE.contains(bizType);
    }

    public static Set<Integer> getReturnBizTypeSet() {
        return RETURN_BIZ_TYPE;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private SellerAccountBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        EXPEND_BIZ_TYPE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{WITHDRAW.getCode(), REFUND.getCode()}));
        ONLY_CHANGE_BALANCE_BIZ_TYPE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{WITHDRAW.getCode(), WITHDRAW_BACK.getCode()}));
        RETURN_BIZ_TYPE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{INVITE_AWARD.getCode(), SECOND_INVITE_AWARD.getCode(), FIRST_ORDER_INVITE_AWARD.getCode(), FIRST_ORDER_INVITE_EXTRA_AWARD.getCode(), SP_INVITE_AWARD.getCode(), ENOUGH_COMMISSION_AWARD.getCode(), PARTNERSHIP_INVITE_AWARD.getCode(), SECOND_PARTNERSHIP_INVITE_AWARD.getCode(), PARTNERSHIP_INVITE_RENEW_AWARD.getCode(), SECOND_PARTNERSHIP_INVITE_RENEW_AWARD.getCode()}));
    }
}

