package cn.com.duiba.kjj.center.api.dto.clue;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 内容互动表，不再局限于问题
 * @author kjj mybatis generator 
 * @date 2021-12-16
 */
@Data
public class ContentInteractionQuestionDto implements Serializable {
     
    private static final long serialVersionUID = 16396395515909089L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 内容id
     */
    private Long contentId;

    /**
     * 内容类型 0日报 1文章 2下午话题 3晚安心语
     */
    private Integer contentType;

    /**
     * 互动类型 0问答题单选 1问答题多选 2投票单选 3投票多选
     */
    private Integer interactionType;

    /**
     * 一级标题，只有早报有
     */
    private String oneTitle;

    /**
     * 标题
     */
    private String title;

    /**
     * 答案说明
     */
    private String instructions;

    /**
     * 是否启用配置 0不启用 1启用
     */
    private Integer enableConfig;

    /**
     * 代理人内容id 对应tb_seller_content表id
     */
    private Long scId;

    /**
     * 互动来源- 0-文章内配置的互动，1-保险小课堂，2-销售员模板，3-销售员配置
     */
    private Integer interactionSource;

    /**
     * 是否删除
     */
    private Integer deleted;

    /**
     * 投票基础值
     */
    private Integer voteCountBase;
}