package cn.com.duiba.kjj.center.api.dto.clue;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户转载
 * @author kjj mybatis generator 
 * @date 2021-12-21
 */
@Data
public class UserForwardDto implements Serializable {
     
    private static final long serialVersionUID = 16400717361588145L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 转发人id 对应tb_users中id
     */
    private Long userId;

    /**
     * 内容id 对应tb_content中id
     */
    private Long contentId;

    /**
     * 代理人内容id 对应tb_seller_content中id
     */
    private Long scId;

    /**
     * 代理人id 对应tb_seller中id
     */
    private Long sellerId;

    /**
     * 是否已读 0-未读 1-已读
     */
    private Integer readMark;

    /**
     * 对应访问记录id
     */
    private Long visitId;

    /**
     * 销售员转发途径 0:未知 1:个人/微信群 2:朋友圈
     */
    private Integer forwardType;

    /**
     * 内容类型：对应tb_content.content_type
     */
    private String contentType;
}