package cn.com.duiba.kjj.center.api.dto.greetingCard;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户参与贺卡记录表
 * @author kjj mybatis generator 
 * @date 2022-01-17
 */
@Data
public class VisitorGreetingCardRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16424074662226707L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 贺卡ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_greeting_card_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 是否感谢：0-未答谢，1-答谢
     */
    private Integer thanks;

    /**
     * 答谢时间
     */
    private Date thanksTime;

    /**
     * 答谢图片
     */
    private String thanksImgUrl;

    /**
     * 领取金额
     */
    private Integer receivedAmount;

    /**
     * 领取红包时间
     */
    private Date receivedTime;

    /**
     * 领取状态 0：未领取 1：领取成功 2：领取失败 3：领取中
     */
    private Integer receivedState;

    /**
     * 订单号
     */
    private String tradeNo;

    /**
     * 红包祝福语
     */
    private String redPacketBlessWord;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 红包配置id，对应tb_seller_red_packet_conf.id
     */
    private Long redPacketId;

    /**
     * 礼物领取记录id，对应tb_visitor_marketing_gift_record.id
     */
    private String giftRecordId;

    /**
     * 是否已通知代理人补货 0：未通知 1：已通知
     */
    private Integer replenishState;

    /**
     * 失败码信息
     */
    private String failCode;

    /**
     * 给代理人的留言
     */
    private String tags;

    /**
     * 访客手机号
     */
    private String phoneNum;
}