package cn.com.duiba.kjj.center.api.dto.provider;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客集集服务商渠道表
 * @author kjj mybatis generator
 * @date 2021-12-21
 */
@Data
public class ProviderChannelDto implements Serializable {
    private static final long serialVersionUID = 2680448874687221597L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 简短描述
     */
    private String channelName;

    /**
     * 渠道类型：1:个微公众号 2:企业应用 3:第三方APP
     * @see cn.com.duiba.kjj.center.api.enums.provider.ProviderChannelEnum
     */
    private Integer channelType;

    /**
     * 渠道ID，和channel_type联合使用。
     * @see cn.com.duiba.kjj.center.api.enums.provider.ProviderChannelEnum
     */
    private Long channelBizId;

    /**
     *公众号ID。当type = 2｜3 此字段就是用户授权的公众号，当type=1时此字段等于channel_biz_id
     */
    private Long authOaId;

    /**
     * 状态：1:生效 0:不生效
     */
    private Integer channelState;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
