package cn.com.duiba.kjj.center.api.dto.push;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-12 14:15
 * 消息配置
 */
@Data
public class MessageConfigDto implements Serializable {
    private static final long serialVersionUID = 5173383914638946184L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 消息的唯一标示
     */
    private Integer messageMark;

    /**
     * 从属公众号 目前是有当 message_type = 1时有特殊性，0：all
     */
    private Long oaId;

    /**
     * 描述
     */
    private String comment;

    /**
     * 微信唯一标志，如templateID
     */
    private String wxId;

    /**
     * 模版。属性用{{key}}标志。[n]标示换行
     */
    private String template;

    /**
     * 1：模版消息，2：客服文字消息，3:客服图文消息 4:发送图片 5：群发消息
     */
    private Byte messageType;

    /**
     * 1：公众号，2：小程序
     */
    private Byte messageTarget;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
