package cn.com.duiba.kjj.center.api.enums.clue;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 代理人动态业务类型枚举
 *
 * @author xuzhigang
 * @date 2021/11/29 4:25 下午
 **/
@Getter
@AllArgsConstructor
public enum SellerDynamicBizTypeEnum {

    USER_FORWARD(1, "转发记录"),
    USER_VISIT(2, "访问记录"),
    SELLER_CLUE(3, "销售线索"),
    FOLLOW_CUSTOMER(4, "跟进客户"),
    ;
    /**
     * 枚举值
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    /**
     * 根据code获取枚举
     * @param code 枚举值
     * @return 枚举
     */
    public static SellerDynamicBizTypeEnum getByCode(Integer code) {
        for (SellerDynamicBizTypeEnum enumVal : SellerDynamicBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 根据code获得描述
     *
     * @param code 枚举值
     * @return 枚举描述
     */
    public static String getDescByCode(Integer code) {
        for (SellerDynamicBizTypeEnum enumVal : SellerDynamicBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }
}
