package cn.com.duiba.kjj.center.api.enums.vip.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付订单状态枚举
 * @author lizhi
 * @date 2021/11/9 3:05 下午
 */
@Getter
@AllArgsConstructor
public enum SellerPayStatusEnum {

    WAIT(1, "待付款"),
    IN_PAY(2, "付款中"),
    SUCCEED(3, "付款成功"),
    FAILED(4, "付款失败"),
    CANCELED(5, "取消支付"),
    EXCEPTION(6, "支付异常"),
    ALL_REFUND(7, "全额退款"),

    ;

    private final Integer code;

    private final String desc;
}
