package cn.com.duiba.kjj.center.api.param.lottery;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 中奖记录表
 * @author kjj mybatis generator 
 * @date 2022-01-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LotteryWinningRecordSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16423991797332800L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 中奖日期
     */
    private String winningDate;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeImg;

    /**
     * 奖品类型：1-谢谢参与,2-再来一次,3-销售员定制,4-链接优惠券,5-实物
     */
    private Byte prizeType;

    /**
     * 奖品有效期
     */
    private Date prizeEndTime;

    /**
     * 第三方奖品扩展信息，比如券地址、券码等
     */
    private String thirdPrizeExt;

    /**
     * 奖品状态：0-未领取，1-已领取，2-已过期
     */
    private Byte prizeState;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Byte deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 自定义奖品配置表ID，对应tb_activity_custom_prize.id
     */
    private Long activityCustomPrizeId;

    /**
     * 第三方奖项ID
     */
    private Long thirdPrizeId;
}