package cn.com.duiba.kjj.center.api.param.marketing;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 代理人营销礼物配置表
 * @author kjj mybatis generator 
 * @date 2022-01-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SellerMarketingGiftConfSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16424082365204195L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 代理人营销礼物库id，对应tb_seller_marketing_gift.id
     */
    private Long sellerMarketingGiftId;

    /**
     * 礼物名称
     */
    private String giftName;

    /**
     * 礼物图片地址
     */
    private String giftPicUrl;

    /**
     * 礼物总库存
     */
    private Integer totalNum;

    /**
     * 礼物剩余库存
     */
    private Integer surplusNum;

    /**
     * 业务类型，1：贺卡礼物库存
     */
    private Byte bizType;

    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}