package cn.com.duiba.kjj.center.api.param.process;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 审批流程表
 * @author kjj mybatis generator 
 * @date 2021-11-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ProcessFlowSearchParam extends PageQuery {

    private static final long serialVersionUID = 16377204798577991L;

    /**
     * 流程类型：2-用户退款审批
     *
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessFlowTypeEnum
     */
    private Integer flowType;

    /**
     * 审批状态 0:待审批 1:审批通过 2:审批拒绝
     *
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessCheckStatusEnum
     */
    private Integer checkStatus;

    /**
     * 角色类型：1-销售主管 2-财务，3-退款财务
     *
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessRoleTypeEnum
     */
    private Integer checkerRoleType;

    /**
     * 业务ID，退款时为tb_order_refund.id
     */
    private Long outId;
}