package cn.com.duiba.kjj.center.api.param.vip.order;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 销售员付款记录
 * @author kjj mybatis generator 
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SellerPayRecordSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16364423516442198L;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 付款状态，1=待付款、2=付款中、3=付款成功、4=付款失败
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.SellerPayStatusEnum
     */
    private Integer payStatus;

    /**
     * 交易号(业务订单号)
     */
    private String tradeNo;

    /**
     * 微信交易号(微信订单号)
     */
    private String payTradeNo;

    /**
     * 支付结果时间
     */
    private Date payResultTime;
}