package cn.com.duiba.kjj.center.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.clue.SellerCustomerOriginDto;

import java.util.List;

/**
 * 客户来源
 *
 * @author xuzhigang
 * @date 2021/11/30 8:36 上午
 **/
@AdvancedFeignClient
public interface RemoteSellerCustomerOriginService {
    /**
     * 1. 新增客户来源
     * 2. 维护客户链路
     * @param dto 客户来源
     * @return 执行结果
     */
    int insert(SellerCustomerOriginDto dto);

    /**
     * 根据访问id集合查询访问来源
     *
     * @param userVisitIds 访问id集合
     * @return 客户来源
     */
    List<SellerCustomerOriginDto> findByUserVisitIds(List<Long> userVisitIds);
}
