package cn.com.duiba.kjj.center.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.clue.SellerVisitorClueExtDto;

/**
 * 线索扩展信息
 *
 * @author xuzhigang
 * @date 2021/12/24 10:28 上午
 **/
@AdvancedFeignClient
public interface RemoteSellerVisitorClueExtService {

    /**
     * 根据线索id和extName查询
     * @param clueId 线索id
     * @param extName {@link cn.com.duiba.kjj.center.api.enums.clue.ClueExtNameEnum}
     * @return 销售员客户线索扩展
     */
    SellerVisitorClueExtDto selectByClueIdAndExtName(Long clueId, Integer extName);
}
