package cn.com.duiba.kjj.center.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.seller.SellerContentDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-22 16:48
 * 销售素材service
 */
@AdvancedFeignClient
public interface RemoteSellerContentService {

    /**
     * 根据scId获取销售信息和素材信息
     * @param scId 销售素材id
     * @return 销售信息和素材信息
     */
    SellerContentDto findById(Long scId);

    /**
     * 根据scId批量获取销售信息和素材信息
     *
     * @param ids 销售素材id
     * @return 销售信息和素材信息
     */
    List<SellerContentDto> findByIds(List<Long> ids);

    /**
     * 更新阅读数
     *
     * @param id 主键id
     * @return 执行结果
     */
    int increaseReadNum(Long id);

    /**
     * 根据销售id和内容id查询scid
     *
     * @param sellerId 销售id
     * @param contentId 内容id
     * @param contentType 内容类型
     * @return scid
     */
    Long getScid(Long sellerId, Long contentId, String contentType);
}
