/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjj.center.api.enums.clue;

import cn.com.duiba.kjj.center.api.enums.advice.AdviceTypeEnum;
import cn.com.duiba.kjy.api.api.enums.PushEventEnum;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum ClueBizTypeEnum {
    EXPLOSION_VOTE(1, PushEventEnum.EXPLOSION_VOTE.getEventType(), null, "\u79cd\u8349\u7d20\u6750\u5185\u6295\u7968"),
    FAQ_VIEW(2, PushEventEnum.FAQ_VISIT_DETAIL.getEventType(), null, "faq-\u67e5\u770b"),
    FAQ_RECEIVE_DATAGRAM(3, PushEventEnum.FAQ_VISIT_SCAN.getEventType(), AdviceTypeEnum.GET_MATERIAL.getCode(), "faq-\u9886\u53d6\u8d44\u6599\u5305"),
    FAQ_EXTRA_ASK(4, PushEventEnum.FAQ_VISIT_ASK_EXTRA.getEventType(), AdviceTypeEnum.FAQ_QUESTION.getCode(), "faq-\u989d\u5916\u54a8\u8be2"),
    COMPANY_INSURANCE_RECEIVE(5, PushEventEnum.COMPANY_INSURANCE.getEventType(), AdviceTypeEnum.COMPANY_INSURANCE.getCode(), "\u516c\u53f8\u8d60\u9669-\u9886\u53d6"),
    TEST_SUBMIT(6, PushEventEnum.CLUE_ACTIVITY_SUMIT_MATERIAL_3.getEventType(), null, "\u6d4b\u8bc4-\u63d0\u4ea4"),
    TEST_REPORT(7, PushEventEnum.RISK_TEST.getEventType(), AdviceTypeEnum.RISK_TEST.getCode(), "\u6d4b\u8bc4-\u9886\u53d6\u62a5\u544a"),
    INVITATION_LETTER_ACCEPT(8, null, null, "\u9080\u8bf7\u51fd-\u63a5\u53d7\u9080\u8bf7"),
    GREETING_CARD_THANKS(9, null, null, "\u8d3a\u5361-\u611f\u8c22"),
    GREETING_CARD_RED(10, null, null, "\u8d3a\u5361-\u7ea2\u5305"),
    GREETING_CARD_GIFT(11, null, null, "\u8d3a\u5361-\u793c\u7269"),
    LOTTERY_PARTICIPATE(12, null, null, "\u62bd\u5956\u5de5\u5177-\u53c2\u4e0e"),
    LOTTERY_WIN(13, null, null, "\u62bd\u5956\u5de5\u5177-\u4e2d\u5956");

    private final Integer type;
    private final String pushEvent;
    private final Integer adviceType;
    private final String desc;
    private static Map<Integer, ClueBizTypeEnum> map;
    public static final List<Integer> SHOW_CLUE_TYPES;

    public static String getPushEventByType(Integer type) {
        ClueBizTypeEnum clueBizTypeEnum = map.get(type);
        if (Objects.isNull((Object)clueBizTypeEnum)) {
            return null;
        }
        return clueBizTypeEnum.getPushEvent();
    }

    public static Integer getAdviceTypeByType(Integer type) {
        ClueBizTypeEnum clueBizTypeEnum = map.get(type);
        if (Objects.isNull((Object)clueBizTypeEnum)) {
            return null;
        }
        return clueBizTypeEnum.getAdviceType();
    }

    public static ClueBizTypeEnum getByType(Integer type) {
        return map.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getPushEvent() {
        return this.pushEvent;
    }

    public Integer getAdviceType() {
        return this.adviceType;
    }

    public String getDesc() {
        return this.desc;
    }

    private ClueBizTypeEnum(Integer type, String pushEvent, Integer adviceType, String desc) {
        this.type = type;
        this.pushEvent = pushEvent;
        this.adviceType = adviceType;
        this.desc = desc;
    }

    static {
        map = new HashMap<Integer, ClueBizTypeEnum>();
        SHOW_CLUE_TYPES = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{EXPLOSION_VOTE.getType(), FAQ_VIEW.getType(), FAQ_RECEIVE_DATAGRAM.getType(), FAQ_EXTRA_ASK.getType(), COMPANY_INSURANCE_RECEIVE.getType(), TEST_SUBMIT.getType(), TEST_REPORT.getType()}));
        for (ClueBizTypeEnum value : ClueBizTypeEnum.values()) {
            map.put(value.getType(), value);
        }
    }
}

