package cn.com.duiba.kjj.center.api.enums.seller;

import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.Set;

/**
 * 销售员账户明细业务类型枚举
 * @author lizhi
 * @date 2021/11/12 6:49 下午
 */
@Getter
@AllArgsConstructor
public enum SellerAccountBizTypeEnum {

    WITHDRAW(1, "余额提现"),
    INVITE_AWARD(2, "邀请奖励"),
    SECOND_INVITE_AWARD(3, "二级奖励"),
    WITHDRAW_BACK(4, "余额提现失败退回"),
    FIRST_ORDER_INVITE_AWARD(5, "一级阶梯邀请单人奖励"),
    FIRST_ORDER_INVITE_EXTRA_AWARD(6, "一级阶梯邀请一次性奖励"),
    SP_INVITE_AWARD(7, "会销邀请返佣"),
    ENOUGH_COMMISSION_AWARD(8, "满额返佣奖励"),
    TRAIN_AWARD(9, "培训奖励"),
    NOVICE_TASK(10, "新手任务"),
    REFUND(11,"用户退款"),
    PARTNERSHIP_INVITE_AWARD(12, "合伙人一级邀请奖励"),
    SECOND_PARTNERSHIP_INVITE_AWARD(13, "合伙人二级奖励"),
    PARTNERSHIP_INVITE_RENEW_AWARD(14, "合伙人分销续费奖励"),
    SECOND_PARTNERSHIP_INVITE_RENEW_AWARD(15, "合伙人分销二级续费奖励"),
    ATTEND_RED(16, "签到领红包"),
    ;
    private final Integer code;

    private final String desc;

    /**
     * 支出类型的业务类型
     */
    private static final Set<Integer> EXPEND_BIZ_TYPE =
            Collections.unmodifiableSet(Sets.newHashSet(
                    SellerAccountBizTypeEnum.WITHDRAW.getCode(),
                    SellerAccountBizTypeEnum.REFUND.getCode()));

    /**
     * 仅需要变更余额的业务
     */
    private static final Set<Integer> ONLY_CHANGE_BALANCE_BIZ_TYPE =
            Collections.unmodifiableSet(Sets.newHashSet(
                    SellerAccountBizTypeEnum.WITHDRAW.getCode(),
                    SellerAccountBizTypeEnum.WITHDRAW_BACK.getCode()));

    /**
     * 业务是否属于支出类型
     */
    public static boolean isExpend(Integer bizType) {
        return EXPEND_BIZ_TYPE.contains(bizType);
    }

    /**
     * 该业务是否仅仅变更余额
     */
    public static boolean isOnlyChangeBalance(Integer bizType) {
        return ONLY_CHANGE_BALANCE_BIZ_TYPE.contains(bizType);
    }
}
