package cn.com.duiba.kjj.center.api.enums.vip;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * VIP变更原因
 * @author lizhi
 * @date 2021/11/12 3:23 下午
 */
@Getter
@AllArgsConstructor
public enum VipChangeReasonEnum {

    /**
     * 购买套餐1XX
     */
    BUY_COMBO_FIRST(100, "主动购买套餐-首次"),

    /**
     * 购买套餐1XX
     */
    BUY_COMBO_RENEW(101, "主动购买套餐-续费"),

    /**
     * 购买套餐1XX，优惠码续费会员赠送
     */
    PROMOTION_CODE_RENEW_GIVE(102, "优惠码续费会员赠送"),

    /**
     * 购买套餐1XX，普通续费赠送
     */
    ORDINARY_RENEW_GIVE(103, "普通续费赠送"),

    /**
     * 优惠码开通会员赠送，仅限年中大促活动期间内
     */
    @Deprecated
    PROMOTION_ACTIVITY_GIVE(104,"优惠码开通会员赠送"),

    /**
     * 用户退款 2XX
     */
    REFUND(200,"用户退款"),

    /**
     * 用户退款 2XX 扣除之前赠送的天数
     */
    REFUND_SUB_GIVE(201,"用户退款，扣除赠送的天数"),

    /**
     * 奖品派发 3XX
     */
    SELLER_GIFT(300,"奖品派发"),

    /**
     * 激活码 4XX
     */
    ACTIVATION(400,"激活码"),

    /**
     * 会员转移 5XX
     */
    TRANSFER(500,"会员转移"),

    /**
     * 会员关闭
     */
    VIP_CLOSE(501,"会员关闭"),

    /**
     * 预设会员-公司采购 6XX
     */
    @Deprecated
    PRE_COMPANY(600,"预设会员-公司采购"),

    /**
     * 预设会员-内部人员 6XX
     */
    @Deprecated
    PRE_INNER(601,"预设会员-内部人员"),

    /**
     * 预设会员-销售新兵营 6XX
     */
    @Deprecated
    PRE_NEW(602,"预设会员-销售新兵营"),

    /**
     * 预设会员-KP试用账号 6XX
     */
    @Deprecated
    PRE_KP(603,"预设会员-KP试用账号"),

    /**
     * 完成60天开单计划-申请会员奖励 7XX
     */
    @Deprecated
    BILLING_PLAN_VIP_AWARD(700,"完成60天开单计划-申请两个月会员奖励"),

    ;
    private final Integer code;

    private final String desc;
}
