package cn.com.duiba.kjj.center.api.enums.vip.promotion;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 优惠码类型
 * @author lizhi
 * @date 2021/11/9 2:57 下午
 */
@Getter
@AllArgsConstructor
public enum PromotionTypeEnum {

    /**
     * 未知
     */
    TYPE_0(0, 0, 0, false, "未知,展示实际价格"),

    /**
     * 158/半年
     */
    TYPE_1(1, 15800, 6, false, "半年会员(￥158)"),

    /**
     * 186/半年
     */
    TYPE_2(2, 18600, 6, false, "半年会员(￥186)"),

    /**
     * 286/一年
     */
    TYPE_3(3, 28600, 12, false, "一年会员(￥286)"),

    /**
     * 386/一年
     */
    TYPE_4(4, 38600, 12, false, "一年会员(￥386)"),

    /**
     * 365/一年
     */
    TYPE_5(5, 36500, 12, true, "一年会员(¥365)"),

    /**
     * 一年会员(¥265)
     */
    TYPE_6(6, 26500, 12, true, "一年会员(¥265)"),
    ;

    /**
     * 优惠码类型
     */
    private final Integer type;

    /**
     * 价格/分
     */
    private final Integer price;

    /**
     * 会员时长/月
     */
    private final Integer validityDuration;

    /**
     * 是否启用
     */
    private final boolean enable;

    /**
     * 描述
     */
    private final String desc;

}
