package cn.com.duiba.kjj.center.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.seller.SellerDto;
import cn.com.duiba.kjj.center.api.dto.seller.SellerNameAvatarDto;

import java.util.Map;
import java.util.Set;

/**
 * 销售员
 * @author lizhi
 * @date 2021/11/10 6:15 下午
 */
@AdvancedFeignClient
public interface RemoteSellerService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 销售员
     */
    SellerDto selectById(Long id);

    /**
     * 根据用户ID查询
     * @param userId 用户ID
     * @return 销售员信息
     */
    SellerDto selectByUserId(Long userId);

    /**
     * 查询销售员头像昵称
     * @param id 销售员Id
     * @return 销售员头像昵称
     */
    SellerNameAvatarDto getSellerNameAvatar(Long id);

    /**
     * 批量查询销售员头像昵称
     * @param sellerIds 销售员ID集合
     * @return key：销售员ID，value：销售员头像昵称
     */
    Map<Long, SellerNameAvatarDto> getSellerNameAvatarMap(Set<Long> sellerIds);

    /**
     * 业务逻辑上，用户是否成为过有效的vip
     * @param userId 用户ID
     * @return true-业务上认为用户成为过有效的vip，false-业务上认为用户没有成为过有效的vip
     */
    boolean userIsValidVipByBiz(Long userId);

    /**
     * 业务逻辑上，代理人是否成为过有效的vip
     * @param sellerId 销售id
     * @return true-业务上认为用户成为过有效的vip，false-业务上认为用户没有成为过有效的vip
     */
    boolean sellerIsValidVipByBiz(Long sellerId);
}
