package cn.com.duiba.kjj.center.api.remoteservice.vip.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.vip.order.SellerPayRecordDto;
import cn.com.duiba.kjj.center.api.dto.vip.order.SellerPayRecordSaveResultDto;

import java.util.Date;
import java.util.List;

/**
 * 销售员付款记录
 * @author lizhi
 * @date 2021/11/12 11:03 上午
 */
@AdvancedFeignClient
public interface RemoteSellerPayRecordService {

    /**
     * 查询最近支付成功的代理人ID
     * @param size 需要查询的条数
     * @return 最近支付成功的代理人ID集合
     */
    List<Long> selectPaySuccessSeller(int size);

    /**
     * 根据交易号查询
     * @param tradeNo 交易号
     * @return 销售员付款记录
     */
    SellerPayRecordDto selectByTradeNo(String tradeNo);

    /**
     * 查询销售员最后一次支付信息
     * @param sellerId 销售员
     * @return 销售员付款记录
     */
    SellerPayRecordDto selectLastSuccessRecord(Long sellerId);

    /**
     * 保存订单
     * @param dto 订单信息
     * @return 保存结果
     */
    SellerPayRecordSaveResultDto saveOrder(SellerPayRecordDto dto);

    /**
     * 更新订单状态
     * @param id 主键
     * @param status 要更新为的状态
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.SellerPayStatusEnum
     * @param expectStatus 预期的原始状态
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.SellerPayStatusEnum
     * @return 执行结果
     */
    int updateStatus(Long id, Integer status, Integer expectStatus);

    /**
     * 更新订单商户订单号
     * @param id 主键
     * @param outTradeNo 商户订单号
     * @param timeExpire 支付截止时间
     * @return 执行结果
     */
    int updateDuibaTradeNoAndTime(Long id, String outTradeNo, Date timeExpire);

    /**
     * 更新代付人ID
     * @param id 主键
     * @param presentUserId 代付人用户ID
     * @return 执行结果
     */
    int updatePresentUserId(Long id, Long presentUserId);
}
