package cn.com.duiba.kjj.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售员活动访客参与表
 * @author kjj mybatis generator 
 * @date 2021-12-24
 */
@Data
public class SellerActivityVisitDto implements Serializable {
     
    private static final long serialVersionUID = 16403347875984049L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long userId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 活动是否中奖，0=没有奖、1=有奖
     */
    private Integer activityPrizeMark;

    /**
     * 活动奖品名称
     */
    private String activityPrizeName;

    /**
     * 销售员和用户是否绑定为客户，1=绑定、0=未绑定
     */
    private Integer sellerVisitBind;

    /**
     * 参与用户ID，对应tb_users.id
     */
    private Long visitId;

    /**
     * 参与用户名称
     */
    private String visitName;

    /**
     * 用户手机号码
     */
    private String visitPhone;

    /**
     * 用户地址省
     */
    private String visitProvince;

    /**
     * 用户地址市
     */
    private String visitCity;

    /**
     * 用户地址区
     */
    private String visitDistrict;

    /**
     * 用户详细地址
     */
    private String visitAddrDetail;

    /**
     * 用户拓展信息
     */
    private String visitExtra;

    /**
     * 处理标注，0=未读、1=已读
     */
    private Integer readMark;

    /**
     * 活动奖品图片
     */
    private String activityPrizeImg;

    /**
     * 表单是否提交完成，0=未完成、1=完成
     */
    private Integer completed;

    /**
     * 用户访问记录表的id,tb_users_visit.id
     */
    private Long tableVisitId;

    /**
     * 愿意接受沟通状态0-不愿意 1-愿意
     */
    private Integer acceptState;
}