package cn.com.duiba.kjj.center.api.dto.explosion;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 爆款素材文章表
 * @author kjj mybatis generator 
 * @date 2021-12-27
 */
@Data
public class ExplosionContentDto implements Serializable {
     
    private static final long serialVersionUID = 16405752224933634L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * tb_content主键ID
     */
    private Long contentId;

    /**
     * tb_admin_article_collection主键ID
     */
    private Long articleCollectionId;

    /**
     * 精准素材类型 1:爆款素材 2:必转素材
     */
    private Integer explosionContentType;

    /**
     * 素材分类，对应tb_accurate_tag主键id
     */
    private Long classify;

    /**
     * 文章内标签，最多三个标签，每个标签不超过6个字，标签之间用英文逗号隔开
     */
    private String tags;

    /**
     * 推荐理由
     */
    private String recommendReason;

    /**
     * 自定义标签
     */
    private String customTag;

    /**
     * 发布时间
     */
    private Date releaseTime;

    /**
     * 内容状态:0:不可用 1:可用
     */
    private Integer contentStatus;

    /**
     * 险种属性标签id，对应tb_accurate_tag的主键id
     */
    private Long insurancePropertyTag;

    /**
     * 转发量
     */
    private Integer shareNum;

    /**
     * 是否删除，1=已删除
     */
    private Integer deleted;

    /**
     * 素材标题
     */
    private String title;

    /**
     * 素材oss
     */
    private String img;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 是否热文(0:否 1:是)
     */
    private Integer isHotContent;
}