package cn.com.duiba.kjj.center.api.dto.interact.clockin;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 打卡总进度
 * @author kjj mybatis generator 
 * @date 2021-11-26
 */
@Data
public class SellerClockInProgressDto implements Serializable {
     
    private static final long serialVersionUID = 1637911036762158L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 打卡规则配置id
     */
    private Long clockInRuleConfId;

    /**
     * 打卡类型 1-180天打卡
     * @see cn.com.duiba.kjj.center.api.enums.interact.clockin.SellerClockInTypeEnum
     */
    private Integer clockInType;

    /**
     * 状态 1-进行中 2-完成 3-失败 4-发放奖励中 5-审核 6-发放完成
     * @see cn.com.duiba.kjj.center.api.enums.interact.clockin.SellerClockInStatusEnum
     */
    private Integer clockInStatus;

    /**
     * 打卡开始时间
     */
    private Date clockInBeginTime;

    /**
     * 打卡结束时间
     */
    private Date clockInEndTime;

    /**
     * 业务id 业务类型为优惠码时表示tb_promotion_batch.id
     */
    private Long bizId;

    /**
     * 业务来源类型 1-优惠码
     * @see cn.com.duiba.kjj.center.api.enums.interact.clockin.SellerClockInBizTypeEnum
     */
    private Integer bizType;

    /**
     * 已打卡次数
     */
    private Integer doneTimes;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}