package cn.com.duiba.kjj.center.api.enums.advice;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 建议话术类型
 *
 * @author xuzhigang
 * @date 2021/12/27 1:58 下午
 **/
@Getter
@AllArgsConstructor
public enum AdviceTypeEnum {

    /**
     * faq关联问答
     */
    FAQ_QUESTION(1, "faq关联问答"),
    /**
     * 咨询问题
     */
    ASK_QUESTION(2, "咨询问题"),
    /**|
     * 领取资料
     */
    GET_MATERIAL(3,"领取资料"),
    /**
     * 领取赠险
     */
    GET_INSURANCE(4,"领取赠险"),
    /**
     * 风险评测
     */
    RISK_TEST(5,"风险评测"),
    /**
     * 1V1定制
     */
    ONE_BY_ONE(6,"1V1定制"),
    /**
     * 投保咨询
     */
    INSURE_ADVICE(7,"投保咨询"),

    /**
     * 保费测算
     */
    INSURE_CALCULATE(8,"保费测算"),

    /**
     * 文内抽奖
     */
    ARTICLE_PRIZE(9,"文内抽奖"),

    /**
     * 公司专区赠险
     */
    COMPANY_INSURANCE(10, "公司专区赠险"),
    ;

    private final Integer code;
    private final String desc;
}
