package cn.com.duiba.kjj.center.api.enums.clue;

import cn.com.duiba.kjj.center.api.enums.advice.AdviceTypeEnum;
import cn.com.duiba.kjy.api.api.enums.PushEventEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 线索类型
 *
 * @author xuzhigang
 * @date 2021/12/10 2:54 下午
 **/
@Getter
@AllArgsConstructor
public enum ClueBizTypeEnum {
    EXPLOSION_VOTE(1, PushEventEnum.EXPLOSION_VOTE.getEventType(), null, "种草素材内投票"),
    FAQ_VIEW(2, PushEventEnum.FAQ_VISIT_DETAIL.getEventType(), null, "faq-查看"),
    FAQ_RECEIVE_DATAGRAM(3, PushEventEnum.FAQ_VISIT_SCAN.getEventType(), AdviceTypeEnum.GET_MATERIAL.getCode(), "faq-领取资料包"),
    FAQ_EXTRA_ASK(4, PushEventEnum.FAQ_VISIT_ASK_EXTRA.getEventType(), AdviceTypeEnum.FAQ_QUESTION.getCode(), "faq-额外咨询"),
    COMPANY_INSURANCE_RECEIVE(5, PushEventEnum.COMPANY_INSURANCE.getEventType(), AdviceTypeEnum.COMPANY_INSURANCE.getCode(), "公司赠险-领取"),
    TEST_SUBMIT(6, PushEventEnum.CLUE_ACTIVITY_SUMIT_MATERIAL_3.getEventType(), null, "测评-提交"),
    TEST_REPORT(7, PushEventEnum.RISK_TEST.getEventType(), AdviceTypeEnum.RISK_TEST.getCode(), "测评-领取报告"),
    INVITATION_LETTER_ACCEPT(8, null, null, "邀请函-接受邀请"),
    GREETING_CARD_THANKS(9, null, null, "贺卡-感谢"),
    GREETING_CARD_RED(10, null, null, "贺卡-红包"),
    GREETING_CARD_GIFT(11, null, null, "贺卡-礼物"),
    LOTTERY_PARTICIPATE(12, null, null, "抽奖工具-参与"),
    LOTTERY_WIN(13, null, null, "抽奖工具-中奖"),
    ;

    /**
     * 线索类型
     */
    private final Integer type;

    /**
     * 线索对应推送事件 没有则不会推送
     * {@link PushEventEnum}
     */
    private final String pushEvent;

    /**
     * 建议话术类型 没有的话查询不到建议话术
     * {@link cn.com.duiba.kjj.center.api.enums.advice.AdviceTypeEnum}
     */
    private final Integer adviceType;

    /**
     * 描述
     */
    private final String desc;

    private static Map<Integer, ClueBizTypeEnum> map = new HashMap<>();

    static {
        for (ClueBizTypeEnum value : values()) {
            map.put(value.getType(), value);
        }
    }

    /**
     * 根据线索类型获取对应的推送事件
     *
     * @param type 线索类型
     * @return 推送事件
     */
    public static String getPushEventByType(Integer type) {
        ClueBizTypeEnum clueBizTypeEnum = map.get(type);
        if (Objects.isNull(clueBizTypeEnum)) {
            return null;
        }
        return clueBizTypeEnum.getPushEvent();
    }

    /**
     * 根据线索类型获取对应的建议类型
     *
     * @param type 线索类型
     * @return 建议类型
     */
    public static Integer getAdviceTypeByType(Integer type) {
        ClueBizTypeEnum clueBizTypeEnum = map.get(type);
        if (Objects.isNull(clueBizTypeEnum)) {
            return null;
        }
        return clueBizTypeEnum.getAdviceType();
    }
}
