package cn.com.duiba.kjj.center.api.enums.seller;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 账户明细状态
 * @author lizhi
 * @date 2021/11/12 6:51 下午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum SellerAccountDetailStateEnum {

    DEALING(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    REFUND(4,"用户退款")
    ;
    private final Integer code;

    private final String desc;

    private static final Map<Integer, SellerAccountDetailStateEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(SellerAccountDetailStateEnum::getCode, Function.identity(), (v1, v2) -> {
                log.error("SellerAccountDetailStateEnum, code distinct, code={}", v2.getCode());
                return v2;
            }))
    );

    public static SellerAccountDetailStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
