package cn.com.duiba.kjj.center.api.param.seller;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 销售员账户流水表
 * @author kjj mybatis generator 
 * @date 2021-11-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SellerAccountDetailSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16370545063355356L;

    /**
     * 流水号
     */
    private Long detailNo;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 变更类型，1:支出；2:收入
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 业务类型，1:余额提现；2:邀请奖励；3:二级奖励;
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务ID
     */
    private String bizId;

    /**
     * 状态，1:处理中；2:成功;3:失败
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountDetailStateEnum
     */
    private Integer state;
}