package cn.com.duiba.kjj.center.api.remoteservice.process;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.process.ProcessRoleDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/11/25 16:49
 * @description 审核角色 - RPC 接口
 */
@AdvancedFeignClient
public interface RemoteProcessRoleApiService {

    /**
     * 根据类型查询角色信息
     *
     * @param roleType 角色类型
     *                 {@link cn.com.duiba.kjj.center.api.enums.process.ProcessRoleTypeEnum}
     * @return 审核角色集合
     */
    List<ProcessRoleDto> listByRoleType(Integer roleType);

    /**
     * 根据sso用户Id查询用户角色
     *
     * @param ssoAdminId sso用户Id
     * @return 审核角色集合
     */
    List<ProcessRoleDto> listBySsoAdminId(Long ssoAdminId);

    /**
     * 新增角色信息
     *
     * @param dto 审核角色
     * @return 执行结果
     */
    int insert(ProcessRoleDto dto);

    /**
     * 删除角色
     *
     * @param id 主键Id
     * @return 执行结果
     */
    int deleteById(Long id);

}
