package cn.com.duiba.kjj.center.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.seller.SellerInvitationDto;

/**
 * 销售员邀请关系表
 * @author lizhi
 * @date 2021/11/12 10:06 上午
 */
@AdvancedFeignClient
public interface RemoteSellerInvitationService {

    /**
     * 通过销售员ID，查询该销售员的绑定关系
     * @param sellerId 销售员ID
     * @return 该销售员的绑定关系
     */
    SellerInvitationDto findBySellerId(Long sellerId);

    /**
     * 删除原有邀请关系并新增（同时修改下级销售员的邀请链路）
     * @param dto 邀请关系
     * @return 操作结果
     */
    boolean delOldAndSaveNew(SellerInvitationDto dto);

    /**
     * 删除原有邀请关系（同时修改下级销售员的邀请链路）
     * @param sid 销售id
     * @return 操作结果
     */
    boolean delOldBySid(Long sid);
}
