package cn.com.duiba.kjj.center.api.utils;

import cn.com.duiba.kjj.center.api.enums.crypto.IdConvertBase64Enum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

import java.net.URLDecoder;
import java.util.Base64;

/**
 * Created by dugq on 2019-10-23.
 *
 * 把ID转换后通过base64编码得出来的值
 * 规律： 以Kj2 开头。第四位为base64结尾'='的个数。避免url encoding
 *       数字部分利用二进制左移3位，后三位补1 把数字变换掉，再base64转码。支持最大值为 2^(64-4)
 * 兼容：旧版本以kjj开头 第四位取原数字第一位补充。 加密已删除，揭秘通过kjj 和 kj2 区分
 * 修改原因： 旧版本太长， 且要处理URL编码问题导致多了一次转换16进制。 加密的主要方案在于 数字左移和补最高位，鉴于base64的高效，所以使用base64encode来美化ID
 *
 * base64加密效率： 加密 1 - 2千万  1s以内完成
 */
@Slf4j
public class IdEncodeByBase64 {

    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();

    private static final int PRE_LENGTH = 3;

    protected IdEncodeByBase64(){}

    protected static String encodingId(Long id, IdConvertBase64Enum base64Enum) {
        if (id == null || base64Enum == null || base64Enum.getCode().length() != PRE_LENGTH) {
            return null;
        }
        id = (id << 3) ^ 7;
        String encode = encoder.encodeToString(Long.toString(id).getBytes());
        String replace = encode.replace("=", "");
        return base64Enum.getCode() + (encode.length() - replace.length()) + replace;
    }

    public static Long decodingId(String encode) {
        if (StringUtils.isBlank(encode)) {
            return null;
        }
        try {
            IdConvertBase64Enum base64Enum = IdConvertBase64Enum.getByCode(encode.substring(0, PRE_LENGTH));
            if(!encode.startsWith("Kj") && base64Enum == null){
                encode =new String(Hex.decodeHex(encode.toCharArray()));
                encode = decoder(encode);
            }
            StringBuilder substring = new StringBuilder(encode.substring(PRE_LENGTH + 1));
            if(encode.startsWith("kj2")){
                int equalNum = (int) encode.charAt(3);
                for (int i  =0 ; i<equalNum; i++){
                    substring.append("=");
                }
            }
            String decode = new String(decoder.decode(substring.toString()));
            return Long.valueOf(decode) >> 3;
        } catch (Exception e) {
            log.info("encode ID error; id = {}",encode,e);
            return null;
        }
    }

    private static String decoder(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        } catch (Exception e) {
        }
        return url;
    }

    public static void main(String[] args) {
        System.out.println(IdEncodeByBase64.encodingId(123L, IdConvertBase64Enum.DEF));
    }
}
