package cn.com.duiba.kjy.base.api.bean.es;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;

/**
 * @author 吴文哲
 * @date 2020/11/9 10:32 上午
 **/
@Data
@AllArgsConstructor
public class QueryCriteriaBean implements Serializable {
    private static final long serialVersionUID = 1833502327610072106L;


    public QueryCriteriaBean() {
    }

    public QueryCriteriaBean(Object val) {
        this.val = val;
    }

    public QueryCriteriaBean(Object val, String analyzer) {
        this.val = val;
        this.analyzer = analyzer;
    }

    public QueryCriteriaBean(Object val, String analyzer, float boost) {
        this.val = val;
        this.analyzer = analyzer;
        this.boost = boost;
    }



    /**
     * 拓展内容
     */
    private Object val;

    /**
     * 标准中文分词器
     * 也可以指定为 ik_max_word
     */
    private String analyzer = "ik_smart";


    /**
     * 权重 默认1.0  数字越大 表示当前查询条件所占的权重越高 会影响最终的_score(得分)排序
     */
    private float boost = 1.0F;

    /**
     * 偏移量
     */
    private int slop = 0;
}
