package cn.com.duiba.kjy.base.api.utils;

import cn.com.duiba.kjy.base.api.constant.DefaultConstant;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-08 09:51
 */
public class StringUtil {

    private StringUtil() {
        //to do something
    }

    /**
     * 手机号匹配表达式
     */
    private static final Pattern PHONE_PATTERN = Pattern.compile("(1|861)((3[0-9])|(5[^4,\\D])|(8[0,5-9]))\\d{8}$*");

    /**
     * 字符串脱敏，只保留前后位的字符，中间字符全部替换成*
     * @param str 需要处理的字符串
     * @param prefix 前面保留位数
     * @param suffix 后面保留位数
     * @param onlyOne 是否只使用一个*脱敏，true：只有一个* false：有多少个字符需要脱敏就有多少*
     * @return 处理过后的字符串
     */
    public static String masking(String str, int prefix, int suffix, boolean onlyOne){

        //如果字符串为空字符
        if (StringUtils.isBlank(str)){
            return str;
        }

        //字符串长度小于等于需要保留的总位数，直接返回原字符串
        int temp = prefix + suffix;
        int length = StringUtils.length(str);
        if (length <= temp){
            return str;
        }
        StringBuilder builder = new StringBuilder(str.substring(0, prefix));

        int needSize = onlyOne ? 1 : length - temp;
        for (int j = 0; j < needSize; j++) {
            builder.append(DefaultConstant.ASTERISK);
        }
        builder.append(str, length - suffix, length);
        return builder.toString();
    }

    /**
     * 获取字符串中包含的手机号
     * @param str 字符串
     * @return 手机号集合
     * */
    public static List<String> getPhoneNum(String str) {

        List<String> result = new ArrayList<>(4);

        if (str == null || str.length() <= 0){
            return result;
        }

        Matcher matcher = PHONE_PATTERN.matcher(str);
        while (matcher.find()) {
            result.add(matcher.group());
        }

        return result;
    }

}
